<?php

use Illuminate\Contracts\Http\Kernel;
use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// If the application is in maintenance mode, load the maintenance file.
if (file_exists($maintenance = __DIR__ . '/storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register Composer autoloader.
require __DIR__ . '/vendor/autoload.php';

// Bootstrap the application.
$app = require_once __DIR__ . '/bootstrap/app.php';

// Handle the incoming request and send the response.
$kernel = $app->make(Kernel::class);

$response = tap($kernel->handle(
    $request = Request::capture()
))->send();

$kernel->terminate($request, $response);
